﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Timers;
using SHDocVw;

namespace IEMonitor
{
    public partial class IEMonitor : ServiceBase
    {
        private Timer timer = null;

        public IEMonitor()
        {
            InitializeComponent();

            timer = new Timer(10000);
            timer.Elapsed += new ElapsedEventHandler(timer_Elapsed);
        }

        void timer_Elapsed(object sender, ElapsedEventArgs e)
        {
            System.Diagnostics.EventLog.WriteEntry("IEMonitor",
                    "Pozdrowienia od usługi IEMonitor");
            try
            {                
                string path = 
                    AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "ie_log.txt";
                System.IO.TextWriter tw = new System.IO.StreamWriter(path, true);
                int i = 0;

                SHDocVw.ShellWindows shellWindows = new SHDocVw.ShellWindows();

                foreach (SHDocVw.InternetExplorer ie in shellWindows)
                {
                    tw.WriteLine("Okno nr " + (++i).ToString() + " "
                        + DateTime.Now.ToShortDateString() + " "
                        + DateTime.Now.ToShortTimeString() + " "
                        + ie.LocationURL);
                }

                tw.Close();
            }
            catch (Exception ex)
            {
                System.Diagnostics.EventLog.WriteEntry("IEMonitor", 
                    "Błąd: " + ex.Message.ToString());
            }
        }

        protected override void OnStart(string[] args)
        {
            timer.Start();            
        }

        protected override void OnStop()
        {
            timer.Stop();
        }

        protected override void OnContinue()
        {
            timer.Start();
            base.OnContinue();
        }

        protected override void OnPause()
        {
            timer.Stop();
            base.OnPause();
        }
    }
}
